/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 3.0 Edition
 BSD License, Use at your own risk
 */

#import "TwitPicOperation.h"

#define NOTIFY_AND_LEAVE(MESSAGE) {[self cleanup:MESSAGE]; return;}
#define DATA(STRING)	[STRING dataUsingEncoding:NSUTF8StringEncoding]
#define SAFE_PERFORM_WITH_ARG(THE_OBJECT, THE_SELECTOR, THE_ARG) (([THE_OBJECT respondsToSelector:THE_SELECTOR]) ? [THE_OBJECT performSelector:THE_SELECTOR withObject:THE_ARG] : nil)

#define HOST    @"twitpic.com"

// Definicja stałych procesu przekazania danych.
#define IMAGE_CONTENT @"Content-Disposition: form-data; name=\"%@\"; filename=\"image.jpg\"\r\nContent-Type: image/jpeg\r\n\r\n"
#define STRING_CONTENT @"Content-Disposition: form-data; name=\"%@\"\r\n\r\n"
#define MULTIPART @"multipart/form-data; boundary=------------0x0x0x0x0x0x0x0x"

@implementation TwitPicOperation
@synthesize imageData, delegate;

- (void) cleanup: (NSString *) output
{
	self.imageData = nil;
    SAFE_PERFORM_WITH_ARG(delegate, @selector(doneTweeting:), output);
}

- (NSData*)generateFormDataFromPostDictionary:(NSDictionary*)dict
{
    id boundary = @"------------0x0x0x0x0x0x0x0x";
    NSArray* keys = [dict allKeys];
    NSMutableData* result = [NSMutableData data];
	
    for (int i = 0; i < [keys count]; i++) 
    {
        id value = [dict valueForKey: [keys objectAtIndex:i]];
        [result appendData:[[NSString stringWithFormat:@"--%@\r\n", boundary] dataUsingEncoding:NSUTF8StringEncoding]];
		
		if ([value isKindOfClass:[NSData class]]) 
		{
			// Obsługa danych obrazu.
			NSString *formstring = [NSString stringWithFormat:IMAGE_CONTENT, [keys objectAtIndex:i]];
			[result appendData: DATA(formstring)];
			[result appendData:value];
		}
		else 
		{
			// Zakładamy, że wszystkie pola niezwiązane z obrazem będą ciągami tekstowymi.
			NSString *formstring = [NSString stringWithFormat:STRING_CONTENT, [keys objectAtIndex:i]];
			[result appendData: DATA(formstring)];
			[result appendData:DATA(value)];
		}
		
		NSString *formstring = @"\r\n";
        [result appendData:DATA(formstring)];
    }
	
	NSString *formstring =[NSString stringWithFormat:@"--%@--\r\n", boundary];
    [result appendData:DATA(formstring)];
    return result;
}

- (void) main
{
	if (!self.imageData)
		NOTIFY_AND_LEAVE(@"BŁĄD: wybierz obraz przed wysłaniem danych.");

    NSURLProtectionSpace *protectionSpace = [[NSURLProtectionSpace alloc] initWithHost:HOST port:0 protocol:@"http" realm:nil authenticationMethod:nil];
    
    NSURLCredential *credential = [[NSURLCredentialStorage sharedCredentialStorage] defaultCredentialForProtectionSpace:protectionSpace];
    if (!credential)
        NOTIFY_AND_LEAVE(@"BŁĄD: nie podano danych uwierzytelniających.")

    NSString *uname = credential.user;
    NSString *pword = credential.password;

	if (!uname || !pword || (!uname.length) || (!pword.length))
		NOTIFY_AND_LEAVE(@"BŁĄD: Przed wysłaniem wiadomości proszę w ustawieniach podać dane uwierzytelniające.");
	
	NSMutableDictionary* post_dict = [[NSMutableDictionary alloc] init];
	[post_dict setObject:uname forKey:@"username"];
	[post_dict setObject:pword forKey:@"password"];
	[post_dict setObject:@"Wysłane z iTweet" forKey:@"message"];
	[post_dict setObject:self.imageData forKey:@"media"];
	
	// Utworzenie formularza przekazania danych na podstawie słownika.
	NSData *postData = [self generateFormDataFromPostDictionary:post_dict];
	
	// Utworzenie żądania API.
    // Użyj upload zamiast uploadAndPost, aby pominąć wiadomość w serwisie Twitter.
    NSString *baseurl = @"http://twitpic.com/api/upload"; 
    NSURL *url = [NSURL URLWithString:baseurl];
    NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:url];
    if (!urlRequest) NOTIFY_AND_LEAVE(@"BŁĄD: Błąd podczas tworzenia adresu URL żądania");
	
    [urlRequest setHTTPMethod: @"POST"];
	[urlRequest setValue:MULTIPART forHTTPHeaderField: @"Content-Type"];
    [urlRequest setHTTPBody:postData];
	
	// Wysłanie danych i otrzymanie wyniku.
    NSError *error;
    NSURLResponse *response;
	NSLog(@"Nawiązuję połączenie z serwisem TwitPic....");
    NSData* result = [NSURLConnection sendSynchronousRequest:urlRequest returningResponse:&response error:&error];
    if (!result)
	{
		[self cleanup:[NSString stringWithFormat:@"Błąd podczas wysyłania danych: %@", [error localizedFailureReason]]];
		return;
	}
	
	// Zwrot wyników.
    NSString *outstring = [[NSString alloc] initWithData:result encoding:NSUTF8StringEncoding];
	[self cleanup: outstring];
}

+ (id) operationWithDelegate: (id) delegate andPath: (NSString *) path
{
    NSData *data = [NSData dataWithContentsOfFile:path];
    if (!data) return nil;
    
    TwitPicOperation *op = [[TwitPicOperation alloc] init];
    op.delegate = delegate;
    op.imageData = data;
    
    return op;
}
@end